// ============================================================================
// Movo Network API Sample
//
// <ApiSample6.c>
//
// Copyright (c) 2009 Servoland corporation.
// All rights reserved.
//
// Purpose:
//		hCõMOf[^PCɍ]܂B
//
// Versions:						  -- Despription --
//		Version 1.0		2009.08.10	: First construction.
//
// ============================================================================
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "MovoEther.h"	// Library header

#include <windows.h>	// for Sleep function

// =============================================================================
// O[oϐ
// =============================================================================
int iDevSel=0;		// ʐMfoCX=Ethernet
char ID;			// hCo

// =============================================================================
// vg^Cv錾
// =============================================================================
int Initialize();	// ʐM
void Logging();		// MO֐

// =============================================================================
// Gg[|Cg
// =============================================================================
int main(){
	int iRc;
	iRc=Initialize();
	if(iRc!=0)
		return -1;

	Logging();

	return 0;
}

// =============================================================================
// 
// =============================================================================
int Initialize(){
	char szIP[20];	// IPAhX
	char szSN[20];	// Tulbg}XN
	char szBuf[256];
	int i;			// JE^
	int iRc;		// ߂l
	int IFNum;		// I/F̐
	int IFSel;		// gpI/F

	// APĨo[W擾
	GetLibVersion(szBuf);
	printf("Network API version %s\n\n",szBuf);

	// I/Fݒ(Ethernetgp)
	if(iDevSel==0){
		// gp\Ethernet I/F
		IFNum=SearchInterface(iDevSel);
		if(IFNum<=0){
			printf("No ethernet I/F found\n");
			return -1;
		}
		printf("%d Ethernet I/Fs found\n",IFNum);
		
		// eI/F̏\
		for(i=0;i<IFNum;i++){
			GetHostIP(iDevSel,i,szIP,NULL);
			GetHostSN(iDevSel,i,szSN,NULL);
			printf("    %d : %-16s (%-16s)\n",i,szIP,szSN);
		}

		if(IFNum==1){
			// I/FP̂Ƃ͎I
			IFSel=0;
		}else{
			// I/FQȏ̂Ƃ̓[UI
			do{
				printf("Select I/F to use [0-%d]> ",IFNum-1);
				scanf("%s",szBuf);
				IFSel=atoi(szBuf);
			}while(IFSel<0 || IFSel>=IFNum);
		}
		printf("I/F %d selected\n\n",IFSel);

		// Ethernet I/Fݒ
		SetInterface(iDevSel,IFSel);
	}

	// ڑꂽhCǒ
	iRc=SearchDevice(iDevSel,szBuf);
	if(iRc<=0){
		printf("No driver found\nBye\n");
		return -1;
	}
	ID=szBuf[0];

	// ڑ\ȂׂẴhCoɐڑ
	iRc=ConnectAll(iDevSel,szBuf);
	if(iRc>0){
		printf("Driver [%s] connected\n",szBuf);
	}else{
		printf("No driver found\nBye\n");
		return -1;
	}

	return 0;
}



// =============================================================================
// ]ɂ郍MOf[^̎擾
// =============================================================================
void Logging(){
	int i;
	int iRc;			// ߂l
	char szBuf[256];	// obt@
	long data[4000];	// MOf[^
	MOVO_VAR2 m_var;	// ]̂߂̍\
	COM_BIN cb_logp;	// R}hAhX\
	unsigned long logp;	// MO|C^
	FILE *fp;			// f[^CSVt@Cɕۑ邽߂̃t@C|C^

	// MÖ̐擪AhXݒ
	m_var.address=0x0008C000;

	// ݒ
	SetComID(iDevSel, ID);

	// LOGPɃR}hg킸ɃANZX邽߃AhX擾
	printf("Get LOGP\n");
	iRc=GetComAddr(iDevSel,"LOGP",&cb_logp);
	if(iRc==MOVO_FAILURE){
		printf("Error occured at LOGP\n");	
		return;
	}

	// MÖ揉 ("LC")
	printf("LC\n");
	iRc=SendCom(iDevSel, "LC");
	if(iRc==MOVO_FAILURE){
		printf("Error occured at LC\n");	
		return;
	}

	// LC҂(LCLOGP̓MÖ̐擪w)
	do{
		Sleep(100);	// insert interval
		// R}hg킸LOGP擾(R}hgp荂)
		iRc=Movo_ComAddrIO(iDevSel,ID,1,&cb_logp,&logp);
		if(iRc==MOVO_FAILURE){
			printf("Error occured at LOGP through Movo_ComAddrIO\n");	
			return;
		}
		printf("LOGP:%08X\n",logp);
	}while(m_var.address!=logp);
	printf("LC is over\n\n");

	// MO1msɐݒ("LTIME=1")
	printf("LTIME=1\n");
	iRc=SendCom(iDevSel, "LTIME=1");
	if(iRc==MOVO_FAILURE){
		printf("Error occured at LTIME\n");	
		return;
	}

	// MOJn ("L")
	printf("L\n");
	iRc=SendCom(iDevSel, "L");
	if(iRc==MOVO_FAILURE){
		printf("Error occured at L\n");	
		return;
	}
	
	// MOI
	do{
		Sleep(100);	// insert interval
		// R}hg킸LOGP擾(R}hgp荂)
		iRc=Movo_ComAddrIO(iDevSel,ID,1,&cb_logp,&logp);
		if(iRc==MOVO_FAILURE){
			printf("Error occured at LOGP through Movo_ComAddrIO\n");	
			return;
		}
		printf("LOGP:%08X\n",logp);
	}while(m_var.address!=logp);
	printf("L is over\n\n");

	// ------ 獂] ------

    /*
     * ӁF
     *  ]̓R}hgpȂ߁Ả͎ԂȂ܂B
     *  ɂR}hoRł̓]荂ɂȂ܂B
     *  "L"R}hhCoɑMAMOis̏ꍇA]
     *  hCõMOǂzĂ܂ꂪ܂B
     *  邽߂ɂLOGPĎȂf[^]sKv܂B
     *  ̃TvvOł̓MOIɃf[^]̂ŁA
     *  ǂz͔܂B
     */

    // MOVO_VAR2\̂̐ݒ
	m_var.target=0;						// ʏϐ
	m_var.purpose=MOVO_GET32;			// 32rbgϐƂăMOf[^擾
	m_var.total=4000;					// 4ch x 1000s
	m_var.offset=0;						// JñItZbgȂ
	m_var.xfersize=0;					// 1]̃TCY͍ő]

	// ׂẴMOf[^擾
	while(m_var.total!=m_var.offset){
		iRc=Movo_DataIO(iDevSel, ID, &m_var, &data[m_var.offset]);
		if(iRc==MOVO_FAILURE){
			printf("Error occured at Movo_DataIO\n");	
			return;	
		}
	}

	// ------ ܂ō] ------

	printf("Save logging data to [log.csv]\n");
	// ݃[hŃt@CI[v
	fp=fopen("log.csv","w");

	// MOϐ擾
	for(i=1;i<=4;i++){
		// LOGxN
		sprintf(szBuf,"LOG%dN",i);
		iRc=SendCom(iDevSel, szBuf);
		if(iRc==MOVO_FAILURE){
			printf("Error occured at LC\n");	
			return;
		}
		RecvCom(iDevSel,szBuf);
		fprintf(fp,"%s%c",szBuf,(i<4)?',':'\n');
	}

	// f[^̏o
	for(i=0;i<4000;i++){
		fprintf(fp,"%d%c",data[i],(i%4<3)?',':'\n');
	}

	// t@C
	fclose(fp);

	printf("Done\n");
}

