// ============================================================================
/*! \file		MovoEther.h
 *	\brief		MOVO lbg[N`oh wb_t@C
 *
 *	\author		T[{h
 *
 *	\date		2006.08.09
 *
 *	\version	1.25
 *
 *	\par
 *	Copyright (c) 2002-2006 Servoland corporation. <BR>
 *	All rights reserved.
 */
// ============================================================================

#ifndef __MOVOETHER_HEAD__
#define __MOVOETHER_HEAD__

// ============================================================================
// ^`
// ============================================================================
//! unsigned 8 bit ^`
typedef unsigned char uint8;

//! unsigned 16 bit ^`
typedef unsigned short uint16;

//! unsigned 32 bit ^`
typedef unsigned long uint32;

//! signed 8 bit ^`
typedef char int8;

//! signed 16 bit ^`
typedef short int16;

//! signed 32 bit ^`
typedef long int32;

// ============================================================================
// }No^
// ============================================================================
#ifdef WIN32
	#define __WINDOWS__
#else
	#ifdef _Windows
		#define __WINDOWS__
	#endif
#endif


/*!	\def MOVO_API	\brief ֐ĂяoɊւ}N */
#ifdef __WINDOWS__ // For Windows
	#ifdef __EXPORT__
	    #define MOVO_API __declspec( dllexport ) _stdcall
	#else
	    #define MOVO_API __declspec( dllimport ) _stdcall
	#endif
#else	// not defined WIN32
	#define MOVO_API
#endif

// ============================================================================
// \̒`
// ============================================================================
// \̂Aligment1byteɐݒ
#ifdef __WINDOWS__
	#pragma pack(push,1)
#else
	#pragma push
	#pragma pack(1)
#endif 

//! MOVOf[^\
typedef struct{
	uint16	purpose,	//!< Purposel
			length,		//!< f[^
			ad_hi,		//!< ʃAhX
			ad_low;		//!< ʃAhX
}MOVO_VAR;

//!	f[^E擾p\
typedef struct{
	uint32 address;		//!< 擪AhX
	uint16 target;		//!< ^[Qbg
	uint16 purpose;		//!< MOVO_PURPOSEl
	uint16 total;		//!< vf[^
	uint16 offset;		//!< E擾̊Jnvfԍ 
	uint16 xfersize;	//!< P̓](0ȂMOVO_MAX_XFER)
}MOVO_VAR2;

//! DDA\ 
typedef struct{
	uint16	busy,		//!< BusytO
			log_num,	//!< O
			cur_ptr,	//!< ݈ʒu
			fin_ptr;	//!< Iʒu
	int16	mode,		//!< [hi0:wߐp, 1:w&O, 2:Opj
			status;		//!< [hi0:~ 1:I_ 2:Ǐ]j
	uint32	pos,		//!< MOVO݈ʒu
			enc;		//!< GR[_l
	int32	trj;		//!< MOVOOԍ
}DDA_INFO;

//! DDA_DATA̕ʖi݊pj
typedef DDA_INFO CAM_INFO;

//! DDAf[^\
typedef struct{
	int32	data32;		//!< 32bitf[^
	uint32	trj32;		//!< 32bitOՔԍ
}DDA_DATA;

//! DDA_INFO̕ʖi݊pj
typedef DDA_DATA CAM_DATA;

//! Command binary
typedef struct{
	uint32	com_addr,	//!< R}hi[ĂAhXi4byte^j
			com_data;	//!< AhX擾R}hɑ΂ԓi4byte^j
	uint16	com_type;	//!< ̕ϐbyte^\B(0x7:1byte^, 0x2:2byte^, 0x3:4byte^)
}COM_BIN;

// \̂Aligmentɖ߂
#ifdef __WINDOWS__
	#pragma pack(pop)
#else
	#pragma pop
#endif

// ============================================================================
// 萔
// ============================================================================
#define MOVO_MAX_DEV		(32)		///< ő厲
#define MOVO_MAX_DDA		(60)		///< őDDAf[^
#define MOVO_MAX_CAM		MOVO_MAX_DDA	///< MOVO_MAX_DDA̕ʖi݊pj
#define MOVO_MAX_LOG		(50)		///< ő働O
#define MOVO_MAX_XFER		(100)		///< őf[^]

// ߂l
#define MOVO_SUCCESS		(0L)		///< 
#define MOVO_FAILURE		(-1L)		///< s
#define MOVO_NODATA			(0L)		///< f[^
#define MOVO_HASDATA		(1L)		///< f[^

// MOVO Purposel
#define MOVO_SET8			(0x0001)	///<  8bit v
#define MOVO_SET16			(0x0002)	///< 16bit v
#define MOVO_SET32			(0x0004)	///< 32bit v
#define MOVO_GET8			(0x0005)	///<  8bit 擾v
#define MOVO_GET16			(0x0006)	///< 16bit 擾v
#define MOVO_GET32			(0x0008)	///< 32bit 擾v

// MOVO ϐ̃AhX
#define MOVO_CTRL_HEAD		(0x4000)	///< DPRAM̃wb_̏16bit
#define MOVO_CTRL_START		(0x0A00)	///< T[{ϐJnAhX
#define MOVO_CTRL_POSCOM	(0x0A00)	///< ʒuw
#define MOVO_CTRL_POSACT	(0x0A04)	///< ݈ʒu
#define MOVO_CTRL_VELCOM	(0x0A08)	///< xw
#define MOVO_CTRL_VELACT	(0x0A0A)	///< x
#define MOVO_CTRL_TRQCOM	(0x0A0C)	///< gNw
#define MOVO_CTRL_CCAP_U	(0x0A0E)	///< d
#define MOVO_CTRL_TIME32	(0x0A10)	///< 32bit^C}[
#define MOVO_CTRL_TIME		(0x0A14)	///< 16bit^C}[
#define MOVO_CTRL_END		(0x0A16)	///< T[{ϐIAhX

// MOVO G[
#define MOVO_NAK_BUSY		(0xE000)	///< Busy
#define MOVO_NAK_WDATA		(0xE001)	///< Wrong data(j󂳂Ăꍇ܂)
#define MOVO_NAK_WADRS		(0xE002)	///< Wrong address(sAhX)
#define MOVO_NAK_WSIZE		(0xE003)	///< Wrong size(f[^傫)
#define MOVO_NAK_UNDEF		(0xE00F)	///< `ĂȂ(łȂ)v

// LibraryG[
#define MOVO_NAK_CONN		(0xE020)	///< Connection Error
#define MOVO_NAK_WARG		(0xE021)	///< Wrong argument
#define MOVO_NAK_IBUF		(0xE022)	///< Invalid buffer (failed to allocate)
#define MOVO_NAK_WID		(0xE023)	///< Wrong ID
#define MOVO_NAK_TOUT		(0xE024)	///< Timeout
#define MOVO_NAK_FULL		(0xE025)	///< MOVO Full
#define MOVO_NAK_NODEV		(0xE026)	///< No such device
#define MOVO_NAK_NODATA		(0xE027)	///< No data available

// USBG[
#define MOVO_NAK_NODLL		(0xE030)	///< Library doesn't exist

// EthernetG[
#define MOVO_NAK_SEND		(0xE040)	///< MG[
#define MOVO_NAK_RECV		(0xE041)	///< MG[
#define MOVO_NAK_WIP		(0xE042)	///< sIPAhX

// TCP ServerG[
#define MOVO_NAK_SV_NR		(0xE050)	///< Server not ready

// MOVO Purposel
#define MOVO_RET8			(0x0009)	///<  8bit ԐM
#define MOVO_RET16			(0x000A)	///< 16bit ԐM
#define MOVO_RET32			(0x000C)	///< 32bit ԐM

// ============================================================================
// ֐`
// ============================================================================
#ifdef __cplusplus
extern "C"{
#endif
	// Cuo[W̎擾
	void MOVO_API GetLibVersion(
		char *szVer);		// Pointer to buffer

	// C^[tFCX
	int MOVO_API SearchInterface(
		int iDevSel);		// Device selector

	// C^[tFCX̐擾
	int MOVO_API GetInterfaceNum(
		int iDevSel);		// Device selector
	
	// C^[tFCXIPAhX擾
	int MOVO_API GetHostIP(
		int iDevSel,		// Device selector
		int iInterface,		// Interface
		char *szIP,			// IPAhXi[()
		unsigned long *pIP);// IPAhXi[()

	// C^[tFCXIPAhX擾
	int MOVO_API GetHostSN(
		int iDevSel,		// Device selector
		int iInterface,		// Interface
		char *szSN,			// Subnet maski[()
		unsigned long *pSN);// Subnet maski[()

	// gpEthernetC^[tFCXݒ
	int MOVO_API SetInterface(
		int iDevSel,		// Device selector
		int iInterface);	// Interface

	// Sڑ
	int MOVO_API ConnectAll(
		int iDevSel,		// Device selector
		char *szList);		// IDXgi[

	// O[vڑ
	int MOVO_API ConnectGroup(
		int iDevSel,		// Device selector
		char *szList);		// IDXg

	// foCX
	int MOVO_API AddDevice(
		int iDevSel,		// Device selector
		char *pMvID,		// MOVO IDi[
		char *szIP);

	// S폜
	void MOVO_API DisconnectAll(
		int iDevSel);		// Device selector

	// 莲폜
	void MOVO_API DisconnectGroup(
		int iDevSel,		// Device selector
		char *szList);

	// ڑfoCX擾
	int MOVO_API GetConnectedDeviceInfo(
		int iDevSel,		// Device selector
		char *szList);

	// ςݑSfoCX擾
	int MOVO_API GetAllDeviceInfo(
		int iDevSel,		// Device selector
		char *szList);

	// foCX̌
	int MOVO_API SearchDevice(
		int iDevSel,		// Device selector
		char *szList);		// IDXgi[

	// tO擾
	int MOVO_API CheckInit(
		int iDevSel,		// Device selector
		char MvID);			// MOVO ID

	// R}hIDύX
	int MOVO_API SetComID(
		int iDevSel,		// Device selector
		char CommID);		// R}h ID

	// R}hID擾
	int MOVO_API GetComID(
		int iDevSel,		// Device selector
		char *pCommID);		// R}h IDi[

	// R}hM
	int MOVO_API SendCom(
		int iDevSel,		// Device selector
		char *src);			// R}hM

	// R}hM
	int MOVO_API RecvCom(
		int iDevSel,		// Device selector
		char *dest);		// R}hi[

	// R}hAhX擾
	int MOVO_API GetComAddr(
		int iDevSel,		// Device selector
		char *src,			// R}h
		COM_BIN *pCombin);	// AhXi[

	// f[^̑A
	int MOVO_API DataRequest(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int target,			// ^[Qbg(0:ʏϐ 1:ϐ)
		MOVO_VAR *pMVar,	// f[^wb_\
		void *src);			// f[^|C^
	
	// Mf[^擾
	int MOVO_API GetValue(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		void *dest);		// f[^|C^

	// DDA
	int MOVO_API InitDda(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int S_time,			// Tv
		int mode,			// mode
		int feedfwd,		// feed forward ݒ
		DDA_INFO *pInfo);	// DDAi[

	// DDA
	int MOVO_API InitCam(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int S_time,			// Tv
		int mode,			// mode
		int feedfwd,		// feed forward ݒ
		DDA_INFO *pInfo);	// DDAi[

	// DDAf[^M
	int MOVO_API SetDda(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int number,			// f[^
		DDA_DATA *src,		// f[^ւ̃|C^
		DDA_DATA *dest,		// f[^i[
		DDA_INFO *pInfo);	// DDAi[

	// DDAf[^M
	int MOVO_API SetCam(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int number,			// f[^
		DDA_DATA *src,		// f[^ւ̃|C^
		DDA_DATA *dest,		// f[^i[
		DDA_INFO *pInfo);	// DDAi[

	// O擾
	int MOVO_API GetLog(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		uint16 max,			// MOő吔
		uint16 *pNumber,	// MOi[obt@
		DDA_DATA *dest);	// Oi[

	// G[l擾
	int MOVO_API GetError(
		int iDevSel);		// Device selector

	// G[擾
	void MOVO_API GetErrorText(
		int iDevSel,		// Device selector
		char *dest);		// G[i[

	int MOVO_API ConnectServer(
		char *szIP);

	void MOVO_API DisconnectServer();


	// 1.24ȍ~ǉ֐ ----------------------------------------------

	// f[^̑E擾iVj
	int MOVO_API Movo_DataIO(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		MOVO_VAR2 *pMVar2,	// MOVO_VAR2\̂ւ̃|C^
		void *data);		// f[^ւ̃|C^

	// R}hAhX̑E擾
	int MOVO_API Movo_ComAddrIO(
		int iDevSel,		// Device selector
		char MvID,			// MOVO ID
		int mode,			// [h(0:, 1:擾)
		COM_BIN *pCombin,	// COM_BIN\̂ւ̃|C^
		void *data);		// f[^ւ̃|C^

	// AhX32bitlɕϊ
	int MOVO_API Movo_HexToInt(
		const char *szHex);	// 16iւ̃|C^

	// 1.25ȍ~ǉ֐ ----------------------------------------------

	//! ^CAEgݒ
	int MOVO_API Movo_SetTimeout(
		int iDevSel,
		int iLength);		// ^CAEg܂ł̎(msec)

	//! ^CAEg擾
	int MOVO_API Movo_GetTimeout(
		int iDevSel,
		int *piLength);		// ^CAEgli[

#ifdef __cplusplus
}
#endif

#endif // __MOVOETHER_HEAD__



