// ============================================================================
// Movo Network API Sample
//
// <CPP_ApiSample3.cpp>
//
// Copyright (c) 2009 Servoland corporation.
// All rights reserved.
//
// ړIF
//		hCõMOf[^PCɍ]܂B
//
// VersionF					  -- ǉ, C --
//		Version 1.0		2009.08.11	: First construction.
//
// ============================================================================

#include "stdafx.h"

using namespace System;
using namespace System::IO;
using namespace MovoEtherVB::Servoland;

public ref class CPP_ApiSample3
{
private:
	MovoAPI^ api;
	int iDevSel;
    Char ID;
public:
	// ========================================================================
	// 
	// ========================================================================
	int Initialize()
	{
        String^ strBuf = "";	// obt@
        int i;					// Counter
        int iRc;				// Return code
        int IFNum;				// Ethernet I/F̐
        int IFSel;				// gpEthetnet I/F
        String^ strIP = "";		// IPAhX()
        int pIP=0;				// IPAhX()
        String^ strSN = "";		// Tulbg}XN()
        int pSN=0;				// Tulbg}XN()

        api = gcnew MovoAPI();	// MovoAPINX̃CX^X

        iDevSel = 0; // ʐMfoCX=Ethernet

        // APĨo[W擾
        api->GetLibVersion(strBuf);
        strBuf = "Network API version " + strBuf + "\n";

		Console::WriteLine(strBuf);

        // I/Fݒ(Ethernetgp)
        if (iDevSel == 0)
        {
            // gp\Ethernet I/F
            IFNum = api->SearchInterface(iDevSel);
            if (IFNum < 0)
            {
				Console::WriteLine("No ethernet I/F found");
                return -1;
            }

			Console::WriteLine(IFNum.ToString() + " ethernet I/F found");

            // eI/F̏\
            for (i = 0; i < IFNum; i++)
            {
                api->GetHostIP(iDevSel, i, strIP, pIP);
                api->GetHostSN(iDevSel, i, strSN, pSN);
				Console::WriteLine(i.ToString() + " : " + String::Format("{0,-16}", strIP) + "(" + String::Format("{0,-16}", strSN) + ")");
            }

            if (IFNum == 1)
            {
                // I/FP̂Ƃ͎I
                IFSel = 0;
            }
            else
            {
                // I/FQȏ̂Ƃ̓[UI
                do
                {
                    Console::Write("Select I/F to use [0-" + (IFNum - 1).ToString() + "]> ");
                    strBuf = Console::ReadLine();
                    try
                    {
						
						IFSel = Convert::ToInt32(strBuf);
                    }
                    catch(...)
                    {
                        IFSel = -1;
                    }
                } while (IFSel < 0 || IFSel >= IFNum);

            }
            Console::WriteLine("I/F " + IFSel.ToString() + " selected\n");

            // Ethernet I/Fݒ
            api->SetInterface(iDevSel, IFSel);
        }

        // ڑꂽhCǒ
        iRc = api->SearchDevice(iDevSel, strBuf);
        if (iRc <= 0)
        {
            Console::WriteLine("No driver found");
            return -1;
        }
		ID=strBuf->ToCharArray()[0];

        // ڑ\ȂׂẴhCoɐڑ
        iRc = api->ConnectAll(iDevSel, strBuf);
        if (iRc > 0)
        {
            Console::WriteLine("Driver " + strBuf + " connected");
        }
        else
        {
            Console::WriteLine("No driver found");
            return -1;
        }
        return 0;
	}

	// ========================================================================
	// ]ɂ郍MOf[^̎擾
	// ========================================================================
	void Logging()
	{
        int i;
        int iRc;
		array<int>^ data = gcnew array<int>(4000);	// MOf[^
		String^ strBuf;		// obt@
        MOVO_VAR2 m_var;	// ]̂߂̍\
        COM_BIN cb_logp;	// R}hAhX\
        int logp;			// MO|C^

		// MÖ̐擪AhXݒ
        m_var.address = 0x0008C000;

        // ݒ
        api->SetComID(iDevSel, ID);

        // LOGPɃR}hg킸ɃANZX邽߃AhX擾
        strBuf = "LOGP";
		Console::WriteLine(strBuf);
        cb_logp.com_addr = 0;
        cb_logp.com_data = 0;
        cb_logp.com_type = 0;
        iRc = api->GetComAddr(iDevSel, strBuf, cb_logp);
		if (iRc == MovoAPI::MOVO_FAILURE)
        {
			Console::WriteLine("Error occured at LOGP");
            return;
        }

        // MÖ揉 ("LC")
        strBuf = "LC";
		Console::WriteLine(strBuf);
        iRc = api->SendCom(iDevSel, strBuf);
		if (iRc == MovoAPI::MOVO_FAILURE)
        {
			Console::WriteLine("Error occured at LC");
            return;
        }

        // LC҂(LCLOGP̓MÖ̐擪w)
        do
        {
			System::Threading::Thread::Sleep(100);	// insert interval
            // R}hg킸LOGP擾(R}hgp荂)
            logp = 0;
            iRc = api->Movo_ComAddrIO_32(iDevSel, ID, 1, cb_logp, logp);
			if (iRc == MovoAPI::MOVO_FAILURE)
            {
				Console::WriteLine("Error occured at LOGP through Movo_ComAddrIO");
                return;
            }
			strBuf = "0x" + (Convert::ToString(logp, 16))->PadLeft(8, '0');                
			Console::WriteLine(strBuf->ToUpper());
        } while (m_var.address != logp);
		Console::WriteLine("LC is over\n");

        // MO1msɐݒ("LTIME=1")
        strBuf = "LTIME=1";
		Console::WriteLine(strBuf);
        iRc = api->SendCom(iDevSel, strBuf);
		if (iRc == MovoAPI::MOVO_FAILURE)
        {
			Console::WriteLine("Error occured at LTIME");
            return;
        }

        // MOJn ("L")
        strBuf = "L";
		Console::WriteLine(strBuf);
        iRc = api->SendCom(iDevSel, strBuf);
		if (iRc == MovoAPI::MOVO_FAILURE)
        {
			Console::WriteLine("Error occured at L");
            return;
        }

        // MOI
        do
        {
			System::Threading::Thread::Sleep(100);	// insert interval
            // R}hg킸LOGP擾(R}hgp荂)
            logp = 0;
            iRc = api->Movo_ComAddrIO_32(iDevSel, ID, 1, cb_logp, logp);
			if (iRc == MovoAPI::MOVO_FAILURE)
            {
				Console::WriteLine("Error occured at LOGP through Movo_ComAddrIO");
                return;
            }
			strBuf = "0x" + (Convert::ToString(logp, 16))->PadLeft(8, '0');
			Console::WriteLine(strBuf->ToUpper());
        } while (m_var.address != logp);
		Console::WriteLine("L is over\n");

		// ------ 獂] ------

        /*
         * ӁF
         *  ]̓R}hgpȂ߁Ả͎ԂȂ܂B
         *  ɂR}hoRł̓]荂ɂȂ܂B
         *  "L"R}hhCoɑMAMOis̏ꍇA]
         *  hCõMOǂzĂ܂ꂪ܂B
         *  邽߂ɂLOGPĎȂf[^]sKv܂B
         *  ̃TvvOł̓MOIɃf[^]̂ŁA
         *  ǂz͔܂B
         */

        // MOVO_VAR2\̂̐ݒ
        m_var.target = 0;						// ʏϐ
		m_var.purpose = MovoAPI::MOVO_GET32;	// 32rbgϐƂăMOf[^擾
        m_var.total = 4000;					    // 4ch x 1000s
        m_var.offset = 0;						// JñItZbgȂ
        m_var.xfersize = 0;				    	// 1]̃TCY͍ő]

        // ׂẴMOf[^擾
        while (m_var.total != m_var.offset)
        {
            iRc = api->Movo_DataIO_32(iDevSel, ID, m_var, data[m_var.offset]);
			if (iRc == MovoAPI::MOVO_FAILURE)
            {
				Console::WriteLine("Error occured at Movo_DataIO");
                return;
            }
        }

        // ------ ܂ō] ------

		Console::WriteLine("Save logging data to [log.csv]");

        // t@Cݗp̃Xg[
        StreamWriter^ sw = gcnew StreamWriter("log.csv");

        // MOϐ擾
        for (i = 1; i <= 4; i++)
        {
            // LOGxN
			strBuf = "LOG" + i.ToString() + "N";
            iRc = api->SendCom(iDevSel, strBuf);
			if (iRc == MovoAPI::MOVO_FAILURE)
            {
				Console::WriteLine("Error occured at LOGxN");
                return;
            }
            api->RecvCom(iDevSel, strBuf);
            sw->Write(strBuf);
            if (i < 4)
                sw->Write(",");
            else
                sw->Write("\n");
        }

        // f[^̏o
        for (i = 0; i < 4000; i++)
        {
			sw->Write(data[i].ToString());
            if (i % 4 < 3)
                sw->Write(",");
            else
                sw->Write("\n");
        }

        // Xg[
        sw->Close();

		Console::WriteLine("Done");
	}
};

// ============================================================================
// Gg[|Cg
// ============================================================================
int main(array<System::String ^> ^args)
{
	int iRc;
	String ^line;

	CPP_ApiSample3 sample;
	iRc=sample.Initialize();

    if(iRc != 0)
    {
        // s
		Console::WriteLine("Initialization failed (Hit Enter to exit)");
		line = Console::ReadLine();
        return -1;
    }

    sample.Logging();
	return 0;
}

